
import { _decorator, Component, Event, Node, Layout, ScrollView, instantiate, Prefab, Sprite, Label, Color } from 'cc';
import { Consts } from '../Consts';
import { DataConsts } from '../Data/DataConsts';
import { Player } from '../Data/Player';
import { Equip } from '../Data/Sample/Prop/Equip/Equip';
import { Prop } from '../Data/Sample/Prop/Prop';
import { ResourceManager } from '../ResourceManager';
import { UIConfig } from '../UIConfig';
import EventManager from '../UIFrame/EventManager';
import WindowMgr from '../UIFrame/WindowMgr';
import { PropItem } from './Item/PropItem';
const { ccclass, property } = _decorator;

@ccclass('Backpack')
export class Backpack extends Component {

    // 选项卡
    @property(Layout) btnLayout: Layout = null;
    // 滚动栏perfab
    @property(Prefab) scrollViewPrefab: Prefab = null;
    // 道具perfab
    @property(Prefab) propPrefab: Prefab = null;


    start() {
        // 初始化道具列表
        let propSV = instantiate(this.scrollViewPrefab);
        propSV.parent = this.node;
        propSV.getComponentInChildren(ScrollView).name = "ScrollView" + DataConsts.PROP;
        propSV.active = true;
        this.showBPMap(Player.getInstance().getPropsbpMap(), propSV.getComponentInChildren(ScrollView));

        let equpSV = instantiate(this.scrollViewPrefab);
        equpSV.parent = this.node;
        equpSV.getComponentInChildren(ScrollView).name = "ScrollView" + DataConsts.EQUIP;
        equpSV.active = false;
        this.showBPMap(Player.getInstance().getEquipbpMap(), equpSV.getComponentInChildren(ScrollView));


        let gemSV = instantiate(this.scrollViewPrefab);
        gemSV.parent = this.node;
        gemSV.getComponentInChildren(ScrollView).name = "ScrollView" + DataConsts.GEM;
        gemSV.active = false;
        this.showBPMap(Player.getInstance().getGembpMap(), gemSV.getComponentInChildren(ScrollView));


        let cookbookSV = instantiate(this.scrollViewPrefab);
        cookbookSV.parent = this.node;
        cookbookSV.getComponentInChildren(ScrollView).name = "ScrollView" + DataConsts.COOKBOOK;
        cookbookSV.active = false;
        this.showBPMap(Player.getInstance().getCookbookbpMap(), cookbookSV.getComponentInChildren(ScrollView));

        EventManager.addListener(Consts.PRESS_PROP_NODE, this.showPropInfo, this);
    }

    /**
     * 将列表内容显示在指定背包中
     * @param map 道具map
     * @param scrollView 
     */
    private showBPMap(map: Map<number, Prop>, scrollView: ScrollView) {
        scrollView.content.removeAllChildren();
        map.forEach(prop => {
            let propNode = instantiate(this.propPrefab);
            propNode.name = "prop:" + prop.getUid() + ":" + prop.sid + ":" + prop.getCount();
            propNode.getChildByName("bg").getComponent(Sprite).color = Color.RED;
            // 设置图标
            propNode.getChildByName("icon").getComponent(Sprite).spriteFrame = ResourceManager.getPropIcon(prop);
            // 设置数量
            let count = prop.getCount();
            if (count > 1) {
                propNode.getChildByName("count").getComponent(Label).string = "" + count;
            }
            propNode.getComponent(PropItem).prop = prop;
            propNode.parent = scrollView.content;
        })

        //  如果不满足一排, 则补足
        let lastCount = 20 - map.size;
        for (let index = 0; index < lastCount; index++) {
            let propNode = instantiate(this.propPrefab);
            propNode.getChildByName("bg").getComponent(Sprite).color = Color.RED;
            propNode.parent = scrollView.content;
        }

    }

    /**
     * 选项卡按钮按下
     */
    public tabButtonPress(event: Event, data: string) {
        const node = event.target as Node;
        // node.getComponent(Button);
        let scName = "ScrollView" + data;
        // 设置滚动栏状态
        this.node.getComponentsInChildren(ScrollView).forEach(element => {
            if (element.name == scName) {
                element.node.parent.active = true;
            }
            else {
                element.node.parent.active = false;
            }
        });;
    }

    /**
     * 某道具节点上的道具信息提示
     */
    public showPropInfo(prop: Prop) {
        // 判断, 有的界面不需要弹出提示

        // 根据道具不同, 展示不同界面
        if (prop instanceof Equip) {
            // 再判断当前装备是否是已装备的装备
            const uid = prop.getUid();
            const equip = Player.getInstance().getEquipMap().get(uid);
            if (equip) {
                // 弹出单件装备界面
                WindowMgr.open(UIConfig.EquipTipsPanel.prefabPath, prop);
            } else {
                // 身上没有穿这个类型的装备, 则还是弹出单个界面
                const e = prop as Equip;
                const equipType = e.getEquipType();
                let equiped = Player.getInstance().getEquiped(equipType);
                if (equiped) {
                    // 弹出装备对比界面
                    WindowMgr.open(UIConfig.EquipComparePanel.prefabPath, prop);
                }
                else {
                    // 弹出单件装备界面
                    WindowMgr.open(UIConfig.EquipTipsPanel.prefabPath, prop);
                }
            }
        }
        else {
            WindowMgr.open(UIConfig.PropTipsPanel.prefabPath, prop);
        }
    }

}
