
import { _decorator, Component, Node, ScrollView, Prefab, instantiate, Label, Layout, Sprite, Color } from 'cc';
import { Prop } from '../Data/Sample/Prop/Prop';
import { ResourceManager } from '../ResourceManager';
import { ModalOpacity } from '../UIFrame/config/SysDefine';
import { ModalType } from '../UIFrame/Struct';
import { UIWindow } from '../UIFrame/UIWindow';
const { ccclass, property } = _decorator;

@ccclass('CookPanel')
export class CookPanel extends UIWindow {

    modalType = new ModalType(ModalOpacity.OpacityHalf, true, false);                // 阴影类型

    @property(Layout) propLayout: Layout = null;
    @property(Node) bpNode: Node = null;
    @property(Prefab) propNodePrefab: Prefab = null;


    start() {
        this.bpNode.addChild(ResourceManager.getBackpackNode());
        // 四个道具背景
        for (let index = 0; index < 4; index++) {
            let propNode = instantiate(this.propNodePrefab);
            propNode.name = "prop" + index;
            //propNode.getComponent(Prop).sid = -1;
            propNode.getChildByName("bg").getComponent(Sprite).color = Color.RED;
            propNode.parent = this.propLayout.node;
        }
    }


    public onInit() {

    }

    /**
     * 加工
     */
    public cook() {

    }
}