
import { _decorator, Prefab, Node, instantiate } from 'cc';
import { Player } from '../Data/Player';
import { Equip } from '../Data/Sample/Prop/Equip/Equip';
import { ModalOpacity } from '../UIFrame/config/SysDefine';
import { ModalType } from '../UIFrame/Struct';
import { UIWindow } from '../UIFrame/UIWindow';
import { EquipInfo } from './Item/EquipInfo';
const { ccclass, property } = _decorator;
@ccclass('EquipComparePanel')
export class EquipComparePanel extends UIWindow {
    modalType = new ModalType(ModalOpacity.OpacityHalf, true, false);                // 阴影类型

    @property(Node) leftNode: Node = null;
    @property(Node) rightNode: Node = null;


    @property(Prefab) equipInfoPrefab: Prefab = null;

    start() {

    }

    public onShow(params: any) {
        let equipType = 0;
        // 未装备的装备, 在右侧显示
        if (params instanceof Equip) {
            let e = params as Equip;
            let en = instantiate(this.equipInfoPrefab);
            en.getComponent(EquipInfo).equip = e;
            en.getComponent(EquipInfo).show();
            en.parent = this.rightNode;
            equipType = e.getEquipType();
        }

        // 查找已装备的装备
        let equip = Player.getInstance().getEquiped(equipType);
        if (equip) {
            let en = instantiate(this.equipInfoPrefab);
            en.getComponent(EquipInfo).equip = equip;
            en.getComponent(EquipInfo).show();
            en.parent = this.leftNode;
        }
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}