
import { _decorator, Label, Sprite, Layout, Prefab, Node, instantiate } from 'cc';
import { Equip } from '../Data/Sample/Prop/Equip/Equip';
import { Prop } from '../Data/Sample/Prop/Prop';
import { ResourceManager } from '../ResourceManager';
import { ModalOpacity } from '../UIFrame/config/SysDefine';
import { ModalType } from '../UIFrame/Struct';
import { UIWindow } from '../UIFrame/UIWindow';
import { EquipInfo } from './Item/EquipInfo';
const { ccclass, property } = _decorator;
@ccclass('EquipTipsPanel')
export class EquipTipsPanel extends UIWindow {
    modalType = new ModalType(ModalOpacity.OpacityHalf, true, false);                // 阴影类型

    @property(Node) equipInfoNode: Node = null;
    @property(Prefab) equipInfoPrefab: Prefab = null;

    start() {

    }

    public onShow(params: any) {
        if (params instanceof Equip) {
            let e = params as Equip;
            let en = instantiate(this.equipInfoPrefab);
            en.getComponent(EquipInfo).equip = e;
            en.getComponent(EquipInfo).show();
            en.parent = this.equipInfoNode;
        }

    }

    public equip() {

    }

    public sell() {

    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}