
import { _decorator, Component, Node, ScrollView, Prefab, instantiate, Label, Layout, Sprite, Color } from 'cc';
import { Player } from '../Data/Player';
import { FightConsts } from '../Fight/FightConsts';
import { ResourceManager } from '../ResourceManager';
import { ModalOpacity } from '../UIFrame/config/SysDefine';
import { ModalType } from '../UIFrame/Struct';
import { UIWindow } from '../UIFrame/UIWindow';
import { PropItem } from './Item/PropItem';
const { ccclass, property } = _decorator;
@ccclass('HunterHomePanel')
export class HunterHomePanel extends UIWindow {

    modalType = new ModalType(ModalOpacity.OpacityHalf, true, false);                // 阴影类型

    @property(Layout) infoLayout: Layout = null;
    @property(Layout) equipLayout: Layout = null;
    @property(Node) bpNode: Node = null;
    @property(Prefab) equipNodePrefab: Prefab = null;


    start() {
        this.bpNode.addChild(ResourceManager.getBackpackNode());
    }


    public onInit() {
        // 属性
        for (let index = 2; index <= 7; index++) {
            let labelNode = this.infoLayout.node.getChildByName("attr" + index);
            if (labelNode) {
                let label = labelNode.getComponent(Label);
                label.string = FightConsts.ATTRNAMES[index - 2] + ":" + Player.getInstance().fighter.getAttValue(index);
            }
        }
        // 装备
        for (let index = 1; index <= 4; index++) {
            let equip = Player.getInstance().getEquipMap().get(index);
            let equipNode = instantiate(this.equipNodePrefab);
            if (equip) {
                equipNode.getChildByName("icon").getComponent(Sprite).spriteFrame = ResourceManager.getPropIcon(equip);
                equipNode.getChildByName("bg").getComponent(Sprite).color = Color.BLUE;
                equipNode.getComponent(PropItem).prop = equip;
            } else {
                equipNode.getChildByName("bg").getComponent(Sprite).color = Color.RED;
            }
            this.equipLayout.node.addChild(equipNode);
        }

    }
}