
import { _decorator, Component, Node, Sprite, Label, Layout, Prefab } from 'cc';
import { Equip } from '../../Data/Sample/Prop/Equip/Equip';
import { ResourceManager } from '../../ResourceManager';
const { ccclass, property } = _decorator;

@ccclass('EquipInfo')
export class EquipInfo extends Component {

    equip: Equip = null;


    @property(Sprite) icon: Sprite = null;
    @property(Label) nameLabel: Label = null;
    @property(Label) desLabel: Label = null;
    @property(Label) limitLabel: Label = null;
    @property(Layout) attrLayout: Layout = null;
    @property(Prefab) attrLabelPrefab: Prefab = null;

    start() {

    }

    public show() {
        if (!this.equip)
            return;
        this.nameLabel.string = this.equip.sampleName;
        this.desLabel.string = this.equip.des;
        this.icon.spriteFrame = ResourceManager.getPropIcon(this.equip);

    }



}
