
import { _decorator, Component, Event, Node, CCInteger, Enum, ProgressBar, UITransform } from 'cc';
import { Consts } from '../../Consts';
import EventManager from '../../UIFrame/EventManager';
import Utils from '../../Utils';
const { ccclass, property } = _decorator;


export let MapItemType = Enum({
    // 默认0为 未知探索区域
    DEFAULT: 0,
    // 树木, 草丛, 石头, 矿石
    树木: 1, 草丛: 2, 石头: 3, 矿石: 4,
    //河流, 宝箱, 迷雾, 草药, 怪物
    河流: 5, 宝箱: 6, 迷雾: 7, 草药: 8, 怪物: 9
});

// 除了怪物以外, 点击消耗的进度
export let MapItemClickTime = Enum({
    // 默认值为0.2 即点5下
    TEN: 10,
    FIVE: 5,
    FOUR: 4,
    THREE: 3,
    TWO: 2,
    ONE: 1
});

/**
 * 地图物件
 */
@ccclass('MapItem')
export class MapItem extends Component {

    @property({ type: MapItemType, displayName: "物件类型" }) itemType = MapItemType.DEFAULT;
    @property({ type: MapItemClickTime, displayName: "点击次数" }) clickTime = MapItemClickTime.FIVE;
    // 物件编号
    @property(CCInteger) num;

    // 剩余百分比
    progress: number;

    start() {
        let progressBar = this.getComponent(ProgressBar);
        // 重置progressBar的length
        // 水平方向
        if (progressBar.mode == 0) {
            progressBar.totalLength = this.getComponent(UITransform).width;
        } else {
            progressBar.totalLength = this.getComponent(UITransform).height;
        }
    }

    click(event: Event) {
        const node = event.target as Node;
        const progressBar = node.getComponent(ProgressBar);
        if (progressBar.progress <= 0)
            return;

        const v = Utils.numberFixed(1 / this.clickTime, 1);
        const lastV = progressBar.progress - v;

        progressBar.progress = Utils.numberFixed(lastV, 1);
        this.progress = progressBar.progress;

        if (progressBar.progress <= 0) {
            EventManager.emit(Consts.CLICK_ITEM_FINISH, this);
        } else {
            EventManager.emit(Consts.CLICK_ITEM, this);
        }
    }

    resetProgress(value: number) {
        this.node.getComponent(ProgressBar).progress = value;
        this.progress = value;
    }

}




