
import { _decorator, Label, Sprite } from 'cc';
import { Prop } from '../Data/Sample/Prop/Prop';
import { ResourceManager } from '../ResourceManager';
import { ModalOpacity } from '../UIFrame/config/SysDefine';
import { ModalType } from '../UIFrame/Struct';
import { UIWindow } from '../UIFrame/UIWindow';
const { ccclass, property } = _decorator;
@ccclass('PropTipsPanel')
export class PropTipsPanel extends UIWindow {
    modalType = new ModalType(ModalOpacity.OpacityHalf, true, false);                // 阴影类型

    @property(Sprite) icon: Sprite = null;
    @property(Label) nameLabel: Label = null;
    @property(Label) desLabel: Label = null;

    start() {

    }

    public onShow(params: any) {
        if (params instanceof Prop) {
            let p = params as Prop;
            this.nameLabel.string = p.sampleName;
            this.desLabel.string = p.des;
            this.icon.spriteFrame = ResourceManager.getPropIcon(p);
        }

    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}