
import { _decorator, Component, Node, ScrollView, Prefab, instantiate, Label } from 'cc';
import { ModalOpacity } from '../UIFrame/config/SysDefine';
import { ModalType } from '../UIFrame/Struct';
import { UIWindow } from '../UIFrame/UIWindow';
const { ccclass, property } = _decorator;
@ccclass('TaskPanel')
export class TaskPanel extends UIWindow {

    modalType = new ModalType(ModalOpacity.OpacityHalf, true, false);                // 阴影类型

    @property(ScrollView) scrollView: ScrollView = null;
    @property(Prefab) pfItem: Prefab = null;

    start () {
        for(let i=0; i<10; i++) {
            let node = instantiate(this.pfItem);
            node.parent = this.scrollView.content;
            node.getChildByName('lab').getComponent(Label).string = `任务${i}`;
        }
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
}