
import { instantiate, Prefab, resources, SpriteAtlas, SpriteFrame, _decorator, Node } from 'cc';
import { DataConsts } from './Data/DataConsts';
import { Prop } from './Data/Sample/Prop/Prop';
import { UIConfig } from './UIConfig';
import CocosHelper from './UIFrame/CocosHelper';
const { ccclass } = _decorator;

@ccclass('ResourceManager')
export class ResourceManager {
    // 图集资源
    private static equipIconAtlas: SpriteAtlas;
    private static propIconAtlas: SpriteAtlas;
    private static gemIconAtlas: SpriteAtlas;
    private static cookbookIconAtlas: SpriteAtlas;

    // 背包prefab
    private static backpack: Node;

    public static getBackpackNode(): Node {
        return this.backpack;
    }

    /**
     * 加载图集
     */
    public static async atlasInit() {
        resources.load("texture/equip_icon", SpriteAtlas, (err, atlas) => {
            this.equipIconAtlas = atlas;
        });
        resources.load("texture/prop_icon", SpriteAtlas, (err, atlas) => {
            this.propIconAtlas = atlas;
        });

        resources.load("texture/gem_icon", SpriteAtlas, (err, atlas) => {
            this.gemIconAtlas = atlas;
        });

        resources.load("texture/cookbook_icon", SpriteAtlas, (err, atlas) => {
            this.cookbookIconAtlas = atlas;
        });

        let prefab = await CocosHelper.loadResSync(UIConfig.Backpack.prefabPath, Prefab) as Prefab;
        this.backpack = instantiate(prefab);
    }

    /**
     * 根据道具获得他的图标
     */
    public static getPropIcon(prop: Prop): SpriteFrame {
        const type = prop.getPropType();
        let altas: SpriteAtlas;
        switch (type) {
            case DataConsts.PROP:
                altas = this.propIconAtlas;
                break;
            case DataConsts.EQUIP:
                altas = this.equipIconAtlas;
                break;
            case DataConsts.GEM:
                altas = this.gemIconAtlas;
                break;
            case DataConsts.COOKBOOK:
                altas = this.cookbookIconAtlas;
                break;
            default:
                return null;
        }
        return altas.getSpriteFrame(prop.getIcon());
    }

}
