import { Vec2 } from "cc";
import { MoveDir } from "./Types";
import { Broadcast } from "./BroadCast";

export type MapMoveData = {
    currMapId: Vec2;
    targetMapId: Vec2;
    dir: MoveDir;
    delta?: Vec2;
}

export class MapEvent {
    static onBeforMove = new Broadcast<MapMoveData>();
    static onMoveMap = new Broadcast<MapMoveData>();
    static onAfterMove = new Broadcast<MapMoveData>();
}