import { v2, v3, Vec2, view } from "cc";
import { MoveDir } from "./Types";

export default class MapUtils {
    static getMapKey(mapId: Vec2) {
        return mapId.y * 1000 + mapId.x;
    }
    static getNextMap(mapId: Vec2, dir: MoveDir, reverse = 1) {
        if (dir === MoveDir.None) return null;
        switch (dir) {
            case MoveDir.Left:
                return mapId.add(v2(-1 * reverse, 0));
            case MoveDir.Right:
                return mapId.add(v2(1 * reverse, 0));
            // case MoveDir.Up:
            //     return mapId.add(v2(0, 1 * reverse));
            // case MoveDir.Down:
            //     return mapId.add(v2(0, -1 * reverse));
        }
        return mapId;
    }
    static getMapPos(mapId: Vec2) {
        let size = view.getVisibleSize();
        let pos = v3(0, 0, 0);
        pos.x = mapId.x * size.width;
        pos.y = mapId.y * size.height;
        return pos;
    }
    static getMapPosByDir(dir: MoveDir, flag = 1) {
        let size = view.getVisibleSize();
        let targetPos = v3(0, 0);
        switch (dir) {
            case MoveDir.Left:
                targetPos.x = -size.width * flag;
                break;
            case MoveDir.Right:
                targetPos.x = size.width * flag;
                break;
            // case MoveDir.Up:
            //     targetPos.y = size.height * flag;
            //     break;
            // case MoveDir.Down:
            //     targetPos.y = -size.height * flag;
            //     break;Right
        }
        return targetPos;
    }
}