
import { SysDefine } from "./config/SysDefine";
import UIModalScript from "./UIModalScript";
import { ModalType } from "./Struct";
import { Component, find, Node, UITransform, v3, _decorator } from "cc";
import { UIWindow } from "./UIWindow";

/**
 * 遮罩管理
 */
const {ccclass, property} = _decorator;

@ccclass("ModalMgr")
export default class ModalMgr extends Component {
    public static popUpRoot = SysDefine.SYS_UIROOT_NAME + '/' + SysDefine.SYS_POPUP_NODE;
    public static _inst: ModalMgr = null;
    public static get inst() {
        if(this._inst == null) {
            this._inst = new ModalMgr();

            ModalMgr.inst.uiModal = find('Canvas/Modal').getComponent(UIModalScript);
        }
        return this._inst;
    }
    private uiModal:UIModalScript = null;

    /** 为mask添加颜色 */
    private async showModal(maskType: ModalType) {
        await this.uiModal.showModal(maskType.opacity, maskType.easingTime, maskType.isEasing);
    }

    public checkModalWindow(coms: UIWindow[]) {
        if(coms.length <= 0) {
            this.uiModal.node.active = false;
            return ;
        }
        this.uiModal.node.active = true;
        if(this.uiModal.node.parent) {
            this.uiModal.node.removeFromParent();
        }
        for(let i=coms.length-1; i>=0; i--) {
            if(coms[i].modalType.opacity > 0) {
                find(ModalMgr.popUpRoot).addChild(this.uiModal.node);
                this.uiModal.node.setSiblingIndex(Math.max(coms[i].node.getSiblingIndex(), 0));
                this.uiModal.fid = coms[i].fid;
                this.showModal(coms[i].modalType);
                this.uiModal.node.setPosition(v3(0, 0, 0))
                break;
            }
        }
    }
}