import UIManager from "./UIManager";
import { ModalOpacity } from "./config/SysDefine";
import CocosHelper from "./CocosHelper";
import WindowMgr from "./WindowMgr";
import { Asset, BlockInputEvents, Button, Color, Component, EventTouch, Node, resources, sp, Sprite, SpriteFrame, Texture2D, tween, UIOpacity, UITransform, view, _decorator } from "cc";

/**
 * @Author: 邓朗 
 * @Describe: modal
 * @Date: 2019-05-30 23:35:26  
 * @Last Modified time: 2019-05-30 23:35:26 
 */
const {ccclass, property} = _decorator;

@ccclass("UIModalScript")
export default class UIModalScript extends Component {

    public fid: string;

    onLoad() {
        this.node.on('click', this.clickMaskWindow, this);
    }


    // 
    public async showModal(lucenyType: number, time: number = 0.6, isEasing: boolean = true) {
        let o = 0;
        switch (lucenyType) {
            case ModalOpacity.None:    
                this.node.active = false;
            break;        
            case ModalOpacity.OpacityZero:   
                o = 0;
            break;
            case ModalOpacity.OpacityLow:    
                o = 63;
            break;
            case ModalOpacity.OpacityHalf:   
                o = 126;
            break;
            case ModalOpacity.OpacityHigh:
                o = 189;
            break;
            case ModalOpacity.OpacityFull:
                o = 255;
            break;
        }
        if(!this.node.active) return ;
        let com = this.getComponent(UIOpacity);
        if(isEasing) {
            await CocosHelper.runTweenSync<UIOpacity>(com, tween(com).to(time, {opacity: o}));
        }else {
            com.opacity = o;
        }
        // console.log(this.node.active, com.opacity, this.node.position, this.node.parent, this.node.getComponent(UITransform).contentSize, this.node.getComponent(Button))
    }

    public async clickMaskWindow(e) {
        e.propagationStopped = true;
        let com = UIManager.getInstance().getForm(this.fid) as any;
        if(com && com.modalType.clickMaskClose) {
            await WindowMgr.close(this.fid);
        }
    }
}