import { easing, tween, v3, _decorator } from "cc";
import CocosHelper from "./CocosHelper";
import { FormType, ModalOpacity } from "./config/SysDefine";
import { ModalType } from "./Struct";
import UIBase from "./UIBase";
import WindowMgr from "./WindowMgr";

const { ccclass, property } = _decorator;

@ccclass("UIWindow")
export class UIWindow extends UIBase {
    formType = FormType.Window;    
    modalType = new ModalType(ModalOpacity.OpacityHalf, true);                // 阴影类型
    willDestory = true;

    public async closeSelf(): Promise<boolean> {
        return await WindowMgr.close(this.fid);
    }

    /** 显示效果 */
    public async showEffect() {
        // this.node.setScale(v3(0, 0, 0));
        // await CocosHelper.runTweenSync(this.node, tween().to(0.3, {scale: 1, easing: easing.backOut(3.0)}));
    }
}