import { _decorator, Vec2, v2 } from 'cc';
import { Main } from './Main';
import UIManager from './UIFrame/UIManager';
/**
 * 工具类
 */
export default class Utils {

    static getFormKey(formId: Vec2) {
        return formId.x * 10 + formId.y;
    }

    static getOffsetFormId(dir: number, startPos: Vec2, endPos: Vec2) {
        let formOffsetId = v2(0, 0);
        if (dir === 1) {
            formOffsetId = endPos.x > startPos.x ? v2(-1, 0) : v2(1, 0);
        } else {
            formOffsetId = endPos.y > startPos.y ? v2(0, -1) : v2(0, 1);
        }
        return formOffsetId;
    }

    /**
     * 获得本地时间
     */
    static getLocalSecondTime(): number {
        return Main.localTime;
    }

    /**
     * 获得当前时间戳
     */
    static getSecondTime() {
        let d = new Date();
        return d.getTime();
    }

    /**
     * 获得随机数
     */
    static random_num(min: number, max: number) {
        let Range = max - min;
        let Rand = Math.random();
        return (min + Math.round(Rand * Range));
    }

    /**
     * 弹出界面提示框
     */
    static popForm(text: string, okeyFun?: () => boolean, target?: Object) {
        UIManager.getInstance().openForm("FormPrefab/PopForm", {
            text, okeyFun, target
        });
    }

    /**
     * 弹出tips提示
     */
    static popTipsForm(text: string) {
        UIManager.getInstance().openForm("FormPrefab/PopTipsForm", {
            text
        });
    }

    /**
     * 保留小数
     */
    static numberFixed(value: number, digits: number): number {
        return Number(value.toFixed(digits));
    }
}