// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;
cc.macro.ENABLE_TRANSPARENT_CANVAS = true;
@ccclass
export default class NewClass extends cc.Component {

    @property(cc.VideoPlayer)
    videoplayer: cc.VideoPlayer = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start () {
        let that = this;
        this.node.on(cc.Node.EventType.TOUCH_END, (evet) => {
            cc.log("22222");
            that.next(evet);
        }, this);

        this.node.on(cc.Node.EventType.TOUCH_MOVE, (evet) => {
            cc.log("00000");
            // that.node.off(cc.Node.EventType.TOUCH_MOVE, (evet1) => {}, that);
            that.move(evet);
        }, this);

        this.node.on(cc.Node.EventType.TOUCH_CANCEL, (evet) => {
            cc.log("11111");
        }, this);

    }

    vp(){
        this.videoplayer.play();
    }

    next(evet){
        cc.log("touchend 事件调用");
        this.videoplayer.remoteURL = 'https://www.w3school.com.cn/i/movie.mp4';
        this.videoplayer.resourceType = cc.VideoPlayer.ResourceType.REMOTE;
        this.videoplayer.play();
    }


    move(evet){
        var touches = evet.getTouches();
        var touchLoc = touches[0].getLocation();
        let pos = this.node.convertToNodeSpaceAR(cc.v2(touchLoc.x, touchLoc.y));
        cc.log(pos.x + " ----" + pos.y);

    }

    // update (dt) {}
}
