import { ICollisionEvent } from 'cc';
import { CharacterControllerContact, Quat, PhysicsSystem, _decorator, Component, Node, v3, RigidBody, Vec3, find, Camera, SkeletalAnimation, AnimationClip, Collider, CapsuleCharacterController, sys, CapsuleCollider, } from 'cc';
import { EasyController, EasyControllerEvent } from './EasyController';
const { ccclass, property } = _decorator;

const rotation = new Quat();
//const v3_1 = v3();

@ccclass('CharacterController')
export class CharacterController extends Component {

    @property(Camera)
    mainCamera: Camera;

    @property(AnimationClip)
    idleAnimClip: AnimationClip;

    @property(AnimationClip)
    moveAnimClip: AnimationClip;

    @property(AnimationClip)
    jumpBeginAnimClip: AnimationClip;

    @property(AnimationClip)
    jumpLoopAnimClip: AnimationClip;

    @property(AnimationClip)
    jumpLandAnimClip: AnimationClip;
    @property(AnimationClip)
    clamAnimClip: AnimationClip;

    @property(SkeletalAnimation)
    animModel: SkeletalAnimation;
    /**移动速度 */
    @property
    velocity = 1.0;
    /*跳跃速度 */
    @property
    jumpVelocity = 1.0;
    /**重力 */
    @property
    public gravityValue = -9.81;
    /**阻力 */
    @property
    public linearDamping = 0.9;
    /**可以推动的力气 */
    @property
    public pushPower = 4;
    /**最多几段跳 */
    @property
    maxJumpTimes: number = 0;
    private _curJumpTimes: number = 0;


    private characterMover: CapsuleCharacterController;

    /**是否移动状态 */
    private _isMoving: boolean = false;
    /**是否动画切换状态 */
    private _isActing: boolean = false;
    /**是否攀爬状态 */
    private _isClaming: boolean = false;
    /**是否跳跃 */
    private _doJump = false;
    /**是否在地面 */
    private _grounded = null;
    /**当前的速度 */
    private _playerVelocity = new Vec3(0, 0, 0);
    /**最后一次在地面的移动Y轴 */
    private _lastGroundY = 0;
    /**动量 */
    private _movement = new Vec3(0, 0, 0);
    /**摇杆移动缩放 */
    private _velocityScale = 0;



    public standCollider: { [uuid: string]: Collider } = {};
    clamData: { collider?: Collider, pos?: Vec3, normal?: Vec3 } = null;

    start() {
        if (!this.mainCamera) {
            this.mainCamera = find('Main Camera')?.getComponent(Camera);
        }
        if (this.animModel) {
            let clipArr = [
                this.idleAnimClip,
                this.moveAnimClip,
                this.jumpBeginAnimClip,
                this.jumpLoopAnimClip,
                this.jumpLandAnimClip
            ];
            for (let i = 0; i < clipArr.length; ++i) {
                let clip = clipArr[i];
                if (clip) {
                    if (!this.animModel.getState(clip.name)) {
                        this.animModel.addClip(clip);
                    }
                }
            }
            if (this.idleAnimClip) {
                this.animModel.play(this.idleAnimClip.name);
            }
        }

        EasyController.on(EasyControllerEvent.MOVEMENT, this.onMovement, this);
        EasyController.on(EasyControllerEvent.MOVEMENT_STOP, this.onMovementRelease, this);
        EasyController.on(EasyControllerEvent.JUMP, this.onJump, this);
        this.characterMover = this.node.getComponent(CapsuleCharacterController)!;
        if (this.characterMover) {
            this.characterMover.on('onControllerColliderHit', this.onControllerColliderHit, this);
        }


        /* let collider = this.node.getComponent(CapsuleCollider)!;
        if (collider) {
            collider.on('onCollisionStay', (event: ICollisionEvent) => {
                let hasCollider = false;
                for (let i = 0; i < event.contacts.length; i++) {
                    let point = event.contacts[i];
                    let hitPoint = v3();
                    point.getWorldPointOnA(hitPoint);
                    if (hitPoint.y < this.node.worldPosition.y + 0.1) {
                        this.standCollider[event.otherCollider.uuid];
                        hasCollider = true;
                        break;
                    }
                }
                if (!hasCollider) {
                    delete this.standCollider[event.otherCollider.uuid];
                }
                this.isOnAir();
            })
            collider.on('onCollisionExit', (event: ICollisionEvent) => {
                delete this.standCollider[event.otherCollider.uuid];
                this.isOnAir();
            })
        } */
    }

    onControllerColliderHit(hit: CharacterControllerContact) {
        // console.log('Test onColliderHit');
        // console.log('selfCCT ', selfCCT.node.name, ' hitCollider ', hitCollider.node.name);
        // console.log('character velocity ', selfCCT.getVelocity());
        //selfCCT.detectCollisions = false;
        if (hit.worldPosition.y < this.node.worldPosition.y + 0.1) {
            //this._grounded = true;
        }
        return;
        Quat.rotationTo(rotation, Vec3.UNIT_Y, hit.worldNormal);
        /*  this._hitPoint.setWorldPosition(hit.worldPosition);
         scale.set(0.05, 1, 0.05);
         this._hitPoint.setWorldScale(scale);
         this._hitPoint.setWorldRotation(rotation); */

        const body = hit.collider.attachedRigidBody;
        // no rigidbody
        if (body == null || body.isKinematic) {
            return;
        }

        // We dont want to push objects below us
        if (hit.motionDirection.y < -0.1) {
            return;
        }

        // Calculate push direction from move direction,
        // we only push objects to the sides never up and down
        const pushDir = new Vec3(hit.motionDirection.x, 0, hit.motionDirection.z);

        // If you know how fast your character is trying to move,
        // then you can also multiply the push velocity by that.

        // Apply the push
        Vec3.multiplyScalar(pushDir, pushDir, this.pushPower);
        body.setLinearVelocity(pushDir);
    }

    /**判断是否在空中 */
    isOnAir() {
        if (this.characterMover.isGrounded) {
            if (!this._grounded) {
                this._grounded = true;
                this.onLand();
                /* this._lastGroundY = this.node.worldPosition.y;
                if (this._lastGroundY - this.node.worldPosition.y > 0.2) {
                    this.onLand();
                } */
            }
        } else {
            this._grounded = false;
        }
    }

    /**判断能不能爬 */
    tayClam() {
        if (this.clamData) {
            let point = this.clamData.pos.clone();
            point.y = this.node.worldPosition.y;
            let newDir = point.subtract(this.node.worldPosition).normalize();
            let nowDir = this.node.forward.clone().multiplyScalar(-1).normalize();
            /**  点乘相当于cos -1-0为180到90度  0-1为90 到 0度 */
            /**此处则是夹角小于45度 */
            let dotVal = Vec3.dot(newDir, nowDir);
            if (dotVal >= 0.5) {
                newDir.y = 0;
                this.node.forward = newDir.multiplyScalar(-1);
                this.clam(this.clamData.pos);
            }
        }
    }
    /**攀爬结束 */
    clam(pos: Vec3) {
        this._isClaming = true;
        this.node.setWorldPosition(pos);
        /*  this.node.setWorldPosition(this.node.worldPosition.x, pos.y - 0.1, this.node.worldPosition.z);
         tween(this.node).to(0.1, { worldPosition: pos }).start(); */
        this.animModel?.crossFade(this.clamAnimClip?.name);
    }
    clamed() {
        this._isClaming = false;
        if (this.moveAnimClip) {
            if (this._isMoving) {
                this.animModel?.crossFade(this.moveAnimClip.name, 0.5);
            } else {
                this.animModel?.crossFade(this.idleAnimClip.name, 0.5);
            }
        }
    }


    onDestroy() {
        EasyController.off(EasyControllerEvent.MOVEMENT, this.onMovement, this);
        EasyController.off(EasyControllerEvent.MOVEMENT_STOP, this.onMovementRelease, this);
        EasyController.off(EasyControllerEvent.MOVEMENT_STOP, this.onJump, this);
    }

    update(deltaTime: number) {
        if (!this.characterMover)
            return;

        deltaTime = PhysicsSystem.instance.fixedTimeStep;
        if (this._grounded == null) {
            this._grounded = this.characterMover!.isGrounded;
        }
        this.isOnAir();

        if (this._doJump) {
            this._playerVelocity.y += this.jumpVelocity;
            this._doJump = false;
        }
        // damping
        this._playerVelocity.x *= this.linearDamping;
        this._playerVelocity.z *= this.linearDamping;
        if (this.canMove) {
            this._tmp.set(this.node.forward);
            this._tmp.multiplyScalar(-1.0);
            this._tmp.multiplyScalar(this.velocity * this._velocityScale);
            if (this._grounded) {
                this._playerVelocity.z = this._tmp.z;
                this._playerVelocity.x = this._tmp.x;
            } else {
                this._playerVelocity.z = this._tmp.z;
                this._playerVelocity.x = this._tmp.x;
            }
        }
        //grounded
        /* if (this._grounded && this._playerVelocity.y <= 0) {
            this._playerVelocity.y = 0;
        } else { */
        this._playerVelocity.y += this.gravityValue * deltaTime;
        //}
        Vec3.multiplyScalar(this._movement, this._playerVelocity, deltaTime);
        this.characterMover!.move(this._movement);

        if (this._grounded && this._playerVelocity.y <= 0) {
            this._playerVelocity.y = 0;
        }
    }

    get canMove() {
        return this._isMoving && !this._isClaming && !this._isActing;
    }

    /**刚落地 */
    onLand() {
        this._isActing = true;
        this._curJumpTimes = 0;
        this.animModel?.crossFade(this.jumpLandAnimClip.name, 0.5);
    }

    /**落地结束 */
    landed() {
        this._isActing = false;
        if (this.moveAnimClip) {
            if (this._isMoving) {
                this.animModel?.crossFade(this.moveAnimClip.name, 0.5);
            } else {
                this.animModel?.crossFade(this.idleAnimClip.name, 0.5);
            }
        }
    }

    private _tmp = v3();
    /**
     * 移动摇杆
     * @param degree 
     * @param offset 
     */
    onMovement(degree: number, offset: number) {
        if (this._isActing || this._isClaming) {
            return;
        }
        let cameraRotationY = 0;
        if (this.mainCamera) {
            cameraRotationY = this.mainCamera.node.eulerAngles.y;
        }
        this._velocityScale = offset;
        //2D界面是 正X 为 0， 3D场景是 正前方为0，所以需要 - 90 度。（顺时针转90度）
        this._tmp.set(0, cameraRotationY + degree - 90 + 180, 0);
        this.node.setRotationFromEuler(this._tmp.clone());
        if (this.animModel) {
            if (!this._isMoving && this._grounded) {
                if (this.moveAnimClip) {
                    this.animModel?.crossFade(this.moveAnimClip.name, 0.5);
                }
            }
            if (this.moveAnimClip) {
                this.animModel.getState(this.moveAnimClip.name).speed = this._velocityScale;
            }
        }
        this._isMoving = true;
    }
    /**
     * 释放摇杆
     */
    onMovementRelease() {
        if (this._grounded && !this._isActing && !this._isClaming && this.idleAnimClip) {
            this.animModel?.crossFade(this.idleAnimClip.name, 0.5);
        }
        this._isMoving = false;
    }

    /**开始跳起动画 */
    onJump() {
        if (this._isActing || this._isClaming || !this._grounded || this._curJumpTimes >= this.maxJumpTimes) {
            return;
        }
        if (this._curJumpTimes == 0 || true) {
            if (this.jumpBeginAnimClip) {
                this._isActing = true;
                this.animModel?.crossFade(this.jumpBeginAnimClip.name);
            }
        }
        this._curJumpTimes++;
    }
    /**跳起 */
    jumped() {
        this._isActing = false;
        this._doJump = true;
        this.animModel?.crossFade(this.jumpLoopAnimClip.name);
        /* this.scheduleOnce(() => {
            if (this.moveAnimClip) {
                if (this._isMoving) {
                    this.animModel.crossFade(this.moveAnimClip.name, 0.5);
                } else {
                    this.animModel.crossFade(this.idleAnimClip.name, 0.5);
                }
            }
        }, 1); */
    }
}

