// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(dragonBones.ArmatureDisplay)
    dragonDisplay: dragonBones.ArmatureDisplay = null;

    start() {
        var image = 'https://res1.haotgame.com/cu03/static/OpenDoors/Res/dragon/14300002/chuizi_01/chuizi_01_tex.png';
        var ske = 'https://res1.haotgame.com/cu03/static/OpenDoors/Res/dragon/14300002/chuizi_01/chuizi_01_ske.dbbin';
        var atlas = 'https://res1.haotgame.com/cu03/static/OpenDoors/Res/dragon/14300002/chuizi_01/chuizi_01_tex.json';
        cc.assetManager.loadAny([{ url: atlas, ext: '.txt' }, { url: ske, ext: '.dbbin' }], (error, assets) => {
            cc.assetManager.loadRemote(image, (error, texture) => {
                var atlas = new dragonBones.DragonBonesAtlasAsset();
                atlas.atlasJson = assets[0];
                atlas.texture = texture;

                var asset = new dragonBones.DragonBonesAsset();
                asset._nativeAsset = assets[1];

                this.dragonDisplay.dragonAtlasAsset = atlas;
                this.dragonDisplay.dragonAsset = asset;

                this.dragonDisplay.armatureName = 'Armature';
                this.dragonDisplay.playAnimation('chuizi_01', 0);
            });
        });
        
    }

}
