import Player, { playerState } from "./Player";

const {ccclass, property} = cc._decorator;

@ccclass
export default class PlayerStand extends cc.Component {

    @property(Player)
    player: Player | null = null;
        

    onBeginContact(contact, self: cc.Collider, other: cc.Collider) {
        if (other.node.group == 'ground') {
            if (self.tag == 1 && this.player.getState() == playerState.jump) {
                this.player.setAni('player_falldown', playerState.jump);
            }
        }
    }
}
