export function loadPrefab(bundleName: string, prefabUrl: string, cb:(prefab: cc.Prefab | null)=>void) {
    cc.assetManager.loadBundle(bundleName, (err, bundle) => {
        if (err) {
            cb(null);
            return;
        }
        bundle.load(prefabUrl, cc.Prefab, (err, prefab: cc.Prefab) => {
            if (!prefab) {
                cb(null);
                return;
            }
            cb(prefab);
        })
    })
}