
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Demo/Script/Player.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '6edednp2YZKRqJkYeR5jt/f', 'Player');
// Demo/Script/Player.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.playerState = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
exports.playerState = {
    stand: 1,
    jump: 2,
    attack: 3
};
var Player = /** @class */ (function (_super) {
    __extends(Player, _super);
    function Player() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.speedForce = 200.0;
        _this.jumpForce = 200;
        /** 角色的移动速度 */
        _this.speed = cc.v2(0, 0);
        /** 角色的当前行动状态 */
        _this.state = exports.playerState.stand;
        /** 角色的当前动作名称 */
        _this.currentAnim = 'player_idle';
        /** 角色的动画组件 */
        _this.playerAni = null;
        /** 角色的操作输入 */
        _this.keyInput = {};
        /** 角色的连续攻击计数 */
        _this.combo = 0;
        /** 记录角色当前施展连续攻击剩余的时间 */
        _this.leftDelayTime = 0;
        return _this;
    }
    Player.prototype.getState = function () {
        return this.state;
    };
    Player.prototype.onLoad = function () {
        this.playerAni = this.node.getComponent(cc.Animation);
        cc.systemEvent.on('keydown', this.onKeyDown, this);
        cc.systemEvent.on('keyup', this.onKeyUp, this);
    };
    Player.prototype.onDestroy = function () {
        cc.systemEvent.off('keydown', this.onKeyDown, this);
        cc.systemEvent.off('keyup', this.onKeyUp, this);
    };
    Player.prototype.onKeyDown = function (event) {
        this.keyInput[event.keyCode] = 1;
    };
    Player.prototype.onKeyUp = function (event) {
        this.keyInput[event.keyCode] = 0;
    };
    Player.prototype.update = function (dt) {
        // 获取当前刚体的移动速度
        var linearVelocity = this.node.parent.getComponent(cc.RigidBody).linearVelocity;
        // 判断角色是否攻击
        if (this.state == exports.playerState.stand) {
            if (this.keyInput[cc.macro.KEY.j]) {
                if (this.combo == 0) {
                    this.setAni('player_lightattack_01', exports.playerState.attack);
                    linearVelocity.x = -10 * this.node.scaleX;
                    this.leftDelayTime = 0.6;
                    this.combo++;
                }
                else if (this.combo == 1) {
                    this.setAni('player_lightattack_02', exports.playerState.attack);
                    linearVelocity.x = -10 * this.node.scaleX;
                    this.leftDelayTime = 0.6;
                    this.combo++;
                }
                else if (this.combo == 2) {
                    this.setAni('player_lightattack_03', exports.playerState.attack);
                    linearVelocity.x = -15 * this.node.scaleX;
                    this.leftDelayTime = 0;
                    this.combo = 0;
                }
                this.node.parent.getComponent(cc.RigidBody).linearVelocity = linearVelocity;
            }
            else if (this.keyInput[cc.macro.KEY.k]) {
                if (this.combo == 0) {
                    this.setAni('player_heavyattack_01', exports.playerState.attack);
                    linearVelocity.x = -20 * this.node.scaleX;
                    this.leftDelayTime = 1.4;
                    this.combo++;
                }
                else if (this.combo == 1) {
                    this.setAni('player_heavyattack_02', exports.playerState.attack);
                    linearVelocity.x = -25 * this.node.scaleX;
                    this.leftDelayTime = 1.4;
                    this.combo++;
                }
                else if (this.combo == 2) {
                    this.setAni('player_heavyattack_03', exports.playerState.attack);
                    linearVelocity.x = -35 * this.node.scaleX;
                    this.leftDelayTime = 0;
                    this.combo = 0;
                }
                this.node.parent.getComponent(cc.RigidBody).linearVelocity = linearVelocity;
            }
        }
        // 假定攻击时无法移动或者跳跃
        if (this.state != exports.playerState.attack) {
            // 获取当前是否按下方向键
            if (this.keyInput[cc.macro.KEY.a]) {
                this.speed.x = -1;
                this.node.scaleX = 1;
                if (this.state == exports.playerState.stand) {
                    this.setAni('player_run', exports.playerState.stand);
                }
            }
            else if (this.keyInput[cc.macro.KEY.d]) {
                this.speed.x = 1;
                this.node.scaleX = -1;
                if (this.state == exports.playerState.stand) {
                    this.setAni('player_run', exports.playerState.stand);
                }
            }
            else {
                this.speed.x = 0;
                if (this.state == exports.playerState.stand) {
                    this.setAni('player_idle', exports.playerState.stand);
                }
            }
            // 判断当前是否处于跳跃状态
            if (this.state == exports.playerState.stand) {
                if (this.keyInput[cc.macro.KEY.space]) {
                    linearVelocity.y = this.jumpForce;
                    this.setAni('player_jump', exports.playerState.jump);
                }
            }
            // 处理新的移动速度
            if (this.speed.x) {
                linearVelocity.x = this.speed.x * this.speedForce;
            }
            else {
                this.speed.x = 0;
            }
            this.node.parent.getComponent(cc.RigidBody).linearVelocity = linearVelocity;
        }
        // 如果角色处于跳跃状态
        if (this.state == exports.playerState.jump) {
            if (linearVelocity.y < 0) {
                this.setAni('player_fall', exports.playerState.jump);
            }
        }
        // 判断角色是否重置连续攻击计数
        if (this.leftDelayTime != 0) {
            this.leftDelayTime -= dt;
            if (this.leftDelayTime <= 0) {
                this.leftDelayTime = 0;
                this.combo = 0;
            }
        }
    };
    Player.prototype.setAni = function (anim, state) {
        if (this.currentAnim == anim)
            return;
        this.state = state;
        this.currentAnim = anim;
        this.playerAni.play(anim);
    };
    Player.prototype.resetAttack = function () {
        this.state = exports.playerState.stand;
    };
    Player.prototype.onBeginContact = function (contact, self, other) {
        if (other.node.group == 'ground') {
            if (self.tag == 1 && this.state == exports.playerState.jump) {
                this.setAni('player_falldown', exports.playerState.jump);
            }
        }
    };
    Player.prototype.printColliderOffset = function () {
        var thisNodeOffset = this.node.getComponent(cc.BoxCollider).offset;
        var childNodeOffset = this.node.getChildByName('player_attack').getComponent(cc.BoxCollider).offset;
        cc.log('This node offset = ', thisNodeOffset.x.toFixed(3), thisNodeOffset.y.toFixed(3));
        cc.log('Child node offset = ', childNodeOffset.x.toFixed(3), childNodeOffset.y.toFixed(3));
        cc.log('----------------------------------------------');
    };
    __decorate([
        property(cc.Float)
    ], Player.prototype, "speedForce", void 0);
    __decorate([
        property(cc.Float)
    ], Player.prototype, "jumpForce", void 0);
    Player = __decorate([
        ccclass
    ], Player);
    return Player;
}(cc.Component));
exports.default = Player;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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