"use strict";
cc._RF.push(module, '6edednp2YZKRqJkYeR5jt/f', 'Player');
// Demo/Script/Player.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.playerState = void 0;
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
exports.playerState = {
    stand: 1,
    jump: 2,
    attack: 3
};
var Player = /** @class */ (function (_super) {
    __extends(Player, _super);
    function Player() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.speedForce = 200.0;
        _this.jumpForce = 200;
        /** 角色的移动速度 */
        _this.speed = cc.v2(0, 0);
        /** 角色的当前行动状态 */
        _this.state = exports.playerState.stand;
        /** 角色的当前动作名称 */
        _this.currentAnim = 'player_idle';
        /** 角色的动画组件 */
        _this.playerAni = null;
        /** 角色的操作输入 */
        _this.keyInput = {};
        /** 角色的连续攻击计数 */
        _this.combo = 0;
        /** 记录角色当前施展连续攻击剩余的时间 */
        _this.leftDelayTime = 0;
        return _this;
    }
    Player.prototype.getState = function () {
        return this.state;
    };
    Player.prototype.onLoad = function () {
        this.playerAni = this.node.getComponent(cc.Animation);
        cc.systemEvent.on('keydown', this.onKeyDown, this);
        cc.systemEvent.on('keyup', this.onKeyUp, this);
    };
    Player.prototype.onDestroy = function () {
        cc.systemEvent.off('keydown', this.onKeyDown, this);
        cc.systemEvent.off('keyup', this.onKeyUp, this);
    };
    Player.prototype.onKeyDown = function (event) {
        this.keyInput[event.keyCode] = 1;
    };
    Player.prototype.onKeyUp = function (event) {
        this.keyInput[event.keyCode] = 0;
    };
    Player.prototype.update = function (dt) {
        // 获取当前刚体的移动速度
        var linearVelocity = this.node.parent.getComponent(cc.RigidBody).linearVelocity;
        // 判断角色是否攻击
        if (this.state == exports.playerState.stand) {
            if (this.keyInput[cc.macro.KEY.j]) {
                if (this.combo == 0) {
                    this.setAni('player_lightattack_01', exports.playerState.attack);
                    linearVelocity.x = -10 * this.node.scaleX;
                    this.leftDelayTime = 0.6;
                    this.combo++;
                }
                else if (this.combo == 1) {
                    this.setAni('player_lightattack_02', exports.playerState.attack);
                    linearVelocity.x = -10 * this.node.scaleX;
                    this.leftDelayTime = 0.6;
                    this.combo++;
                }
                else if (this.combo == 2) {
                    this.setAni('player_lightattack_03', exports.playerState.attack);
                    linearVelocity.x = -15 * this.node.scaleX;
                    this.leftDelayTime = 0;
                    this.combo = 0;
                }
                this.node.parent.getComponent(cc.RigidBody).linearVelocity = linearVelocity;
            }
            else if (this.keyInput[cc.macro.KEY.k]) {
                if (this.combo == 0) {
                    this.setAni('player_heavyattack_01', exports.playerState.attack);
                    linearVelocity.x = -20 * this.node.scaleX;
                    this.leftDelayTime = 1.4;
                    this.combo++;
                }
                else if (this.combo == 1) {
                    this.setAni('player_heavyattack_02', exports.playerState.attack);
                    linearVelocity.x = -25 * this.node.scaleX;
                    this.leftDelayTime = 1.4;
                    this.combo++;
                }
                else if (this.combo == 2) {
                    this.setAni('player_heavyattack_03', exports.playerState.attack);
                    linearVelocity.x = -35 * this.node.scaleX;
                    this.leftDelayTime = 0;
                    this.combo = 0;
                }
                this.node.parent.getComponent(cc.RigidBody).linearVelocity = linearVelocity;
            }
        }
        // 假定攻击时无法移动或者跳跃
        if (this.state != exports.playerState.attack) {
            // 获取当前是否按下方向键
            if (this.keyInput[cc.macro.KEY.a]) {
                this.speed.x = -1;
                this.node.scaleX = 1;
                if (this.state == exports.playerState.stand) {
                    this.setAni('player_run', exports.playerState.stand);
                }
            }
            else if (this.keyInput[cc.macro.KEY.d]) {
                this.speed.x = 1;
                this.node.scaleX = -1;
                if (this.state == exports.playerState.stand) {
                    this.setAni('player_run', exports.playerState.stand);
                }
            }
            else {
                this.speed.x = 0;
                if (this.state == exports.playerState.stand) {
                    this.setAni('player_idle', exports.playerState.stand);
                }
            }
            // 判断当前是否处于跳跃状态
            if (this.state == exports.playerState.stand) {
                if (this.keyInput[cc.macro.KEY.space]) {
                    linearVelocity.y = this.jumpForce;
                    this.setAni('player_jump', exports.playerState.jump);
                }
            }
            // 处理新的移动速度
            if (this.speed.x) {
                linearVelocity.x = this.speed.x * this.speedForce;
            }
            else {
                this.speed.x = 0;
            }
            this.node.parent.getComponent(cc.RigidBody).linearVelocity = linearVelocity;
        }
        // 如果角色处于跳跃状态
        if (this.state == exports.playerState.jump) {
            if (linearVelocity.y < 0) {
                this.setAni('player_fall', exports.playerState.jump);
            }
        }
        // 判断角色是否重置连续攻击计数
        if (this.leftDelayTime != 0) {
            this.leftDelayTime -= dt;
            if (this.leftDelayTime <= 0) {
                this.leftDelayTime = 0;
                this.combo = 0;
            }
        }
    };
    Player.prototype.setAni = function (anim, state) {
        if (this.currentAnim == anim)
            return;
        this.state = state;
        this.currentAnim = anim;
        this.playerAni.play(anim);
    };
    Player.prototype.resetAttack = function () {
        this.state = exports.playerState.stand;
    };
    Player.prototype.onBeginContact = function (contact, self, other) {
        if (other.node.group == 'ground') {
            if (self.tag == 1 && this.state == exports.playerState.jump) {
                this.setAni('player_falldown', exports.playerState.jump);
            }
        }
    };
    Player.prototype.printColliderOffset = function () {
        var thisNodeOffset = this.node.getComponent(cc.BoxCollider).offset;
        var childNodeOffset = this.node.getChildByName('player_attack').getComponent(cc.BoxCollider).offset;
        cc.log('This node offset = ', thisNodeOffset.x.toFixed(3), thisNodeOffset.y.toFixed(3));
        cc.log('Child node offset = ', childNodeOffset.x.toFixed(3), childNodeOffset.y.toFixed(3));
        cc.log('----------------------------------------------');
    };
    __decorate([
        property(cc.Float)
    ], Player.prototype, "speedForce", void 0);
    __decorate([
        property(cc.Float)
    ], Player.prototype, "jumpForce", void 0);
    Player = __decorate([
        ccclass
    ], Player);
    return Player;
}(cc.Component));
exports.default = Player;

cc._RF.pop();