import { _decorator } from "cc";
import { AudioClip, AudioSource, Component, sys, Node, assetManager, resources } from "cc";
const { ccclass, property } = _decorator;

@ccclass
export class GameAudio extends Component {
  //音效管理
  public effectAudioSource: AudioSource = null!;

  protected static _instance: GameAudio | null;

  public static getInstance(): GameAudio {
    return this._instance!;
  }

  onLoad() {
    console.error("GameAudio.onLoad");
    this.init();
  }

  onDestroy() {
    GameAudio._instance = null;
  }

  /** 重新此方法 */
  public init() {
    console.info("GameAudio.init");
    if (GameAudio._instance) {
      throw new Error(" UnipdkAudio 面板管理已经单例化");
    }
    GameAudio._instance = this;
    let effectNode = new Node();
    let effectAudioSource = effectNode.addComponent(AudioSource);
    effectNode.parent = this.node;
    this.effectAudioSource = effectAudioSource;
  }

  /** 播放音效 */
  public playEffect(dir: string, ...args: string[]) {
    if (!this.effectAudioSource) return;
    let path = "sound/" + dir + args.join("_"); //_.join(args, "_");
    console.log("》》》》》》", AudioSource.maxAudioChannel);
    console.log("加载音效路径:", path);
    resources.load(path, AudioClip, (err, audio) => {
      if (err) {
        console.error("加载音乐失败:", err);
        return;
      }
      if (this.effectAudioSource) {
        this.effectAudioSource?.playOneShot(audio);
      }
    });
  }

  playShunzi() {
    this.playEffect("effect/", "shunzi");
  }
}
