const { ccclass, property } = cc._decorator;

@ccclass
export default class Game2 extends cc.Component {
  @property(cc.Node)
  map: cc.Node = null;

  onLoad() {
    cc.director.getPhysicsManager().enabled = true;
    // 开启物理步长的设置
    cc.director.getPhysicsManager().enabledAccumulator = true;
    cc.director.getPhysicsManager().gravity = cc.director.getPhysicsManager().gravity.scale(cc.v2(2, 2));

    // // 物理步长，默认 FIXED_TIME_STEP 是 1/60
    cc.PhysicsManager.FIXED_TIME_STEP = 1 / 30;

    // // 每次更新物理系统处理速度的迭代次数，默认为 10
    cc.PhysicsManager.VELOCITY_ITERATIONS = 8;

    // // 每次更新物理系统处理位置的迭代次数，默认为 10
    cc.PhysicsManager.POSITION_ITERATIONS = 8;

    cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_shapeBit;
    this.map.on(
      cc.Node.EventType.TOUCH_MOVE,
      (e: cc.Event.EventTouch) => {
        const curPos = this.map.parent.convertToNodeSpaceAR(e.getLocation());
        const prePos = this.map.parent.convertToNodeSpaceAR(e.getPreviousLocation());
        const cross = curPos.cross(prePos);
        if (cross > 0) {
          //顺时针
          this.map.angle -= e.getDelta().mag() / 4;
        } else if (cross < 0) {
          //逆时针
          this.map.angle += e.getDelta().mag() / 4;
        }
        this.map.children.forEach((node) => {
          node.getComponent(cc.RigidBody).syncRotation(false);
          node.getComponent(cc.RigidBody).syncPosition(false);
        });
      },
      this
    );
  }
}
